/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.bidi.browsingcontext.NavigationInfo;
import org.openqa.selenium.json.JsonInput;

public class DownloadCompleted
extends NavigationInfo {
    private final String status;
    private final String filepath;
    private static final String COMPLETE = "complete";

    DownloadCompleted(String browsingContextId, String navigationId, long timestamp, String url, String status, String filepath) {
        super(browsingContextId, navigationId, timestamp, url);
        this.status = Objects.requireNonNullElse(status, COMPLETE);
        this.filepath = filepath;
    }

    public static DownloadCompleted fromJson(JsonInput input) {
        String browsingContextId = null;
        String navigationId = null;
        long timestamp = 0L;
        String url = null;
        String status = COMPLETE;
        String filepath = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    browsingContextId = (String)input.read((Type)((Object)String.class));
                    continue block16;
                }
                case "navigation": {
                    navigationId = (String)input.read((Type)((Object)String.class));
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (Long)input.read((Type)((Object)Long.class));
                    continue block16;
                }
                case "url": {
                    url = (String)input.read((Type)((Object)String.class));
                    continue block16;
                }
                case "status": {
                    status = (String)input.read((Type)((Object)String.class));
                    if (COMPLETE.equals(status)) continue block16;
                    throw new IllegalArgumentException("Expected status 'complete' , but got: " + status);
                }
                case "filepath": {
                    filepath = (String)input.read((Type)((Object)String.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DownloadCompleted(browsingContextId, navigationId, timestamp, url, status, filepath);
    }

    public String getStatus() {
        return this.status;
    }

    public String getFilepath() {
        return this.filepath;
    }
}

