/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BatchLogRecordProcessorBuilder {
    private static final Logger logger = Logger.getLogger(BatchLogRecordProcessorBuilder.class.getName());
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 1000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final LogRecordExporter logRecordExporter;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(1000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private Supplier<MeterProvider> meterProvider = MeterProvider::noop;
    private InternalTelemetryVersion telemetryVersion = InternalTelemetryVersion.LEGACY;

    BatchLogRecordProcessorBuilder(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    public BatchLogRecordProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(delay >= 0L, "delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BatchLogRecordProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BatchLogRecordProcessorBuilder setExporterTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.exporterTimeoutNanos = timeout == 0L ? Long.MAX_VALUE : unit.toNanos(timeout);
        return this;
    }

    public BatchLogRecordProcessorBuilder setExporterTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setExporterTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BatchLogRecordProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        Utils.checkArgument(maxQueueSize > 0, "maxQueueSize must be positive.");
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchLogRecordProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument(maxExportBatchSize > 0, "maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BatchLogRecordProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = () -> meterProvider;
        return this;
    }

    public BatchLogRecordProcessorBuilder setMeterProvider(Supplier<MeterProvider> meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    public BatchLogRecordProcessorBuilder setInternalTelemetryVersion(InternalTelemetryVersion telemetryVersion) {
        Objects.requireNonNull(telemetryVersion, "telemetryVersion");
        this.telemetryVersion = telemetryVersion;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchLogRecordProcessor build() {
        if (this.maxExportBatchSize > this.maxQueueSize) {
            logger.log(Level.WARNING, "maxExportBatchSize should not exceed maxQueueSize. Setting maxExportBatchSize to {0} instead of {1}", new Object[]{this.maxQueueSize, this.maxExportBatchSize});
            this.maxExportBatchSize = this.maxQueueSize;
        }
        return new BatchLogRecordProcessor(this.logRecordExporter, this.meterProvider, this.telemetryVersion, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos);
    }
}

