/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging;

import io.opentelemetry.api.common.Value;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SystemOutLogRecordExporter
implements LogRecordExporter {
    private static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ISO_DATE_TIME;
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public static SystemOutLogRecordExporter create() {
        return new SystemOutLogRecordExporter();
    }

    private SystemOutLogRecordExporter() {
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        StringBuilder stringBuilder = new StringBuilder(60);
        for (LogRecordData log : logs) {
            stringBuilder.setLength(0);
            SystemOutLogRecordExporter.formatLog(stringBuilder, log);
            System.out.println(stringBuilder);
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    static void formatLog(StringBuilder stringBuilder, LogRecordData log) {
        InstrumentationScopeInfo instrumentationScopeInfo = log.getInstrumentationScopeInfo();
        Value<?> body = log.getBodyValue();
        stringBuilder.append(ISO_FORMAT.format(Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(log.getTimestampEpochNanos())).atZone(ZoneOffset.UTC))).append(" ").append((Object)log.getSeverity()).append(" '").append(body == null ? "" : body.asString()).append("' : ").append(log.getSpanContext().getTraceId()).append(" ").append(log.getSpanContext().getSpanId()).append(" [scopeInfo: ").append(instrumentationScopeInfo.getName()).append(":").append(instrumentationScopeInfo.getVersion() == null ? "" : instrumentationScopeInfo.getVersion()).append("] ").append(log.getAttributes());
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            System.out.println("Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        return "SystemOutLogRecordExporter{}";
    }
}

