/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.FieldDefinition;
import graphql.language.IgnoredChars;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class InterfaceTypeDefinition
extends AbstractDescribedNode<InterfaceTypeDefinition>
implements ImplementingTypeDefinition<InterfaceTypeDefinition>,
DirectivesContainer<InterfaceTypeDefinition>,
NamedNode<InterfaceTypeDefinition> {
    private final String name;
    private final ImmutableList<Type> implementz;
    private final ImmutableList<FieldDefinition> definitions;
    private final ImmutableList<Directive> directives;
    public static final String CHILD_IMPLEMENTZ = "implementz";
    public static final String CHILD_DEFINITIONS = "definitions";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    protected InterfaceTypeDefinition(String name, List<Type> implementz, List<FieldDefinition> definitions, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData, description);
        this.name = name;
        this.implementz = ImmutableList.copyOf(implementz);
        this.definitions = ImmutableList.copyOf(definitions);
        this.directives = ImmutableList.copyOf(directives);
    }

    public InterfaceTypeDefinition(String name) {
        this(name, ImmutableKit.emptyList(), ImmutableKit.emptyList(), ImmutableKit.emptyList(), null, null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    @Override
    public List<Type> getImplements() {
        return this.implementz;
    }

    @Override
    public List<FieldDefinition> getFieldDefinitions() {
        return this.definitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.implementz);
        result.addAll(this.definitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_IMPLEMENTZ, this.implementz).children(CHILD_DEFINITIONS, this.definitions).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public InterfaceTypeDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.implementz(newChildren.getChildren(CHILD_IMPLEMENTZ)).definitions(newChildren.getChildren(CHILD_DEFINITIONS)).directives(newChildren.getChildren(CHILD_DIRECTIVES)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterfaceTypeDefinition that = (InterfaceTypeDefinition)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public InterfaceTypeDefinition deepCopy() {
        return new InterfaceTypeDefinition(this.name, this.deepCopy(this.implementz), this.deepCopy(this.definitions), this.deepCopy(this.directives), this.description, this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "InterfaceTypeDefinition{name='" + this.name + "', implements=" + String.valueOf(this.implementz) + ", fieldDefinitions=" + String.valueOf(this.definitions) + ", directives=" + String.valueOf(this.directives) + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInterfaceTypeDefinition(this, context);
    }

    public static Builder newInterfaceTypeDefinition() {
        return new Builder();
    }

    public InterfaceTypeDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Description description;
        private ImmutableList<Type> implementz = ImmutableKit.emptyList();
        private ImmutableList<FieldDefinition> definitions = ImmutableKit.emptyList();
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(InterfaceTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.definitions = ImmutableList.copyOf(existing.getFieldDefinitions());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
            this.implementz = ImmutableList.copyOf(existing.getImplements());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder implementz(List<Type> implementz) {
            this.implementz = ImmutableList.copyOf(implementz);
            return this;
        }

        public Builder implementz(Type implement) {
            this.implementz = ImmutableKit.addToList(this.implementz, implement, new Type[0]);
            return this;
        }

        public Builder definitions(List<FieldDefinition> definitions) {
            this.definitions = ImmutableList.copyOf(definitions);
            return this;
        }

        public Builder definition(FieldDefinition definition) {
            this.definitions = ImmutableKit.addToList(this.definitions, definition, new FieldDefinition[0]);
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public InterfaceTypeDefinition build() {
            return new InterfaceTypeDefinition(this.name, this.implementz, this.definitions, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

