/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.Internal;
import java.util.Arrays;

@Internal
public class LevelMap {
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private int[] countsByLevel;

    public LevelMap(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("negative size " + initialSize);
        }
        this.countsByLevel = new int[initialSize];
    }

    public LevelMap() {
        this(16);
    }

    public int get(int level) {
        this.maybeResize(level);
        return this.countsByLevel[level];
    }

    public void increment(int level, int by) {
        this.maybeResize(level);
        int n = level;
        this.countsByLevel[n] = this.countsByLevel[n] + by;
    }

    public void set(int level, int newValue) {
        this.maybeResize(level);
        this.countsByLevel[level] = newValue;
    }

    private void maybeResize(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("negative level " + level);
        }
        if (level + 1 > this.countsByLevel.length) {
            int newSize = level == 0 ? 1 : level * 2;
            this.countsByLevel = Arrays.copyOf(this.countsByLevel, newSize);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("IntMap[");
        for (int i = 0; i < this.countsByLevel.length; ++i) {
            result.append("level=").append(i).append(",count=").append(this.countsByLevel[i]).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public String toString(int level) {
        StringBuilder result = new StringBuilder();
        result.append("IntMap[");
        for (int i = 1; i <= level; ++i) {
            result.append("level=").append(i).append(",count=").append(this.countsByLevel[i]).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public void clear() {
        Arrays.fill(this.countsByLevel, 0);
    }
}

