/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableMapWithNullValues;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

@PublicApi
public class ExecutionStepInfo {
    private final GraphQLOutputType type;
    private final ResultPath path;
    private final ExecutionStepInfo parent;
    private final MergedField field;
    private final GraphQLFieldDefinition fieldDefinition;
    private final GraphQLObjectType fieldContainer;
    private final Supplier<ImmutableMapWithNullValues<String, Object>> arguments;

    private ExecutionStepInfo(Builder builder) {
        this.fieldDefinition = builder.fieldDefinition;
        this.field = builder.field;
        this.path = builder.path;
        this.parent = builder.parentInfo;
        this.type = Assert.assertNotNull(builder.type, () -> "you must provide a graphql type");
        this.arguments = builder.arguments;
        this.fieldContainer = builder.fieldContainer;
    }

    private ExecutionStepInfo(GraphQLOutputType type, ResultPath path, ExecutionStepInfo parent, MergedField field, GraphQLFieldDefinition fieldDefinition, GraphQLObjectType fieldContainer, Supplier<ImmutableMapWithNullValues<String, Object>> arguments) {
        this.type = Assert.assertNotNull(type, () -> "you must provide a graphql type");
        this.path = path;
        this.parent = parent;
        this.field = field;
        this.fieldDefinition = fieldDefinition;
        this.fieldContainer = fieldContainer;
        this.arguments = arguments;
    }

    public GraphQLObjectType getObjectType() {
        return this.fieldContainer;
    }

    public GraphQLOutputType getType() {
        return this.type;
    }

    public GraphQLOutputType getUnwrappedNonNullType() {
        return (GraphQLOutputType)GraphQLTypeUtil.unwrapNonNull(this.type);
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public MergedField getField() {
        return this.field;
    }

    public ResultPath getPath() {
        return this.path;
    }

    public boolean isNonNullType() {
        return GraphQLTypeUtil.isNonNull(this.type);
    }

    public boolean isListType() {
        return GraphQLTypeUtil.isList(this.type);
    }

    public Map<String, Object> getArguments() {
        return this.arguments.get();
    }

    public <T> T getArgument(String name) {
        return (T)this.getArguments().get(name);
    }

    public ExecutionStepInfo getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ExecutionStepInfo changeTypeWithPreservedNonNull(GraphQLOutputType newType) {
        Assert.assertTrue(!GraphQLTypeUtil.isNonNull(newType), () -> "newType can't be non null");
        if (this.isNonNullType()) {
            return this.transform(GraphQLNonNull.nonNull(newType));
        }
        return this.transform(newType);
    }

    public String simplePrint() {
        return GraphQLTypeUtil.simplePrint(this.type);
    }

    public String toString() {
        return "ExecutionStepInfo{ path=" + String.valueOf(this.path) + ", type=" + String.valueOf(this.type) + ", fieldDefinition=" + String.valueOf(this.fieldDefinition) + "}";
    }

    @Internal
    ExecutionStepInfo transform(GraphQLOutputType type) {
        return new ExecutionStepInfo(type, this.path, this.parent, this.field, this.fieldDefinition, this.fieldContainer, this.arguments);
    }

    @Internal
    ExecutionStepInfo transform(GraphQLOutputType type, ExecutionStepInfo parent, ResultPath path) {
        return new ExecutionStepInfo(type, path, parent, this.field, this.fieldDefinition, this.fieldContainer, this.arguments);
    }

    public ExecutionStepInfo transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String getResultKey() {
        return this.field.getResultKey();
    }

    public static Builder newExecutionStepInfo() {
        return new Builder();
    }

    public static Builder newExecutionStepInfo(ExecutionStepInfo existing) {
        return new Builder(existing);
    }

    public static class Builder {
        GraphQLOutputType type;
        ExecutionStepInfo parentInfo;
        GraphQLFieldDefinition fieldDefinition;
        GraphQLObjectType fieldContainer;
        MergedField field;
        ResultPath path;
        Supplier<ImmutableMapWithNullValues<String, Object>> arguments;

        private Builder() {
            this.arguments = ImmutableMapWithNullValues::emptyMap;
        }

        private Builder(ExecutionStepInfo existing) {
            this.type = existing.type;
            this.parentInfo = existing.parent;
            this.fieldDefinition = existing.fieldDefinition;
            this.fieldContainer = existing.fieldContainer;
            this.field = existing.field;
            this.path = existing.path;
            this.arguments = existing.arguments;
        }

        public Builder type(GraphQLOutputType type) {
            this.type = type;
            return this;
        }

        public Builder parentInfo(ExecutionStepInfo executionStepInfo) {
            this.parentInfo = executionStepInfo;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder field(MergedField field) {
            this.field = field;
            return this;
        }

        public Builder path(ResultPath resultPath) {
            this.path = resultPath;
            return this;
        }

        public Builder arguments(Supplier<ImmutableMapWithNullValues<String, Object>> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder fieldContainer(GraphQLObjectType fieldContainer) {
            this.fieldContainer = fieldContainer;
            return this;
        }

        public ExecutionStepInfo build() {
            return new ExecutionStepInfo(this);
        }
    }
}

