/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.GNImageAligner;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.ProCamTransformer;
import org.bytedeco.javacv.ProjectorDevice;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvPoint;
import org.bytedeco.opencv.opencv_core.CvScalar;
import org.bytedeco.opencv.opencv_core.IplImage;

public class ReflectanceInitializer {
    private static ThreadLocal<CvMat> mat3x1 = CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<CvMat> mat3x3 = CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<CvMat> mat4x4 = CvMat.createThreadLocal(4, 4);
    private GNImageAligner.Settings alignerSettings;
    private int smoothingSize;
    private double reflectanceMin;
    private CameraDevice cameraDevice;
    private ProjectorDevice projectorDevice;
    private IplImage[] projectorImages;

    public ReflectanceInitializer(CameraDevice cameraDevice, ProjectorDevice projectorDevice, int channels, GNImageAligner.Settings alignerSettings) {
        this(cameraDevice, projectorDevice, channels, alignerSettings, 51, 0.01);
    }

    public ReflectanceInitializer(CameraDevice cameraDevice, ProjectorDevice projectorDevice, int channels, GNImageAligner.Settings alignerSettings, int smoothingSize, double reflectanceMin) {
        this.alignerSettings = alignerSettings;
        this.smoothingSize = smoothingSize;
        this.reflectanceMin = reflectanceMin;
        this.cameraDevice = cameraDevice;
        this.projectorDevice = projectorDevice;
        this.projectorImages = new IplImage[3];
        for (int i = 0; i < this.projectorImages.length; ++i) {
            this.projectorImages[i] = IplImage.create(projectorDevice.imageWidth, projectorDevice.imageHeight, 32, channels);
        }
        opencv_core.cvSetZero(this.projectorImages[0]);
        opencv_core.cvSet(this.projectorImages[1], CvScalar.ONE);
        CvMat H = mat3x3.get();
        projectorDevice.getRectifyingHomography(cameraDevice, H);
        JavaCV.fractalTriangleWave(this.projectorImages[2], H);
    }

    public IplImage[] getProjectorImages() {
        return this.projectorImages;
    }

    public IplImage initializeReflectance(IplImage[] cameraImages, IplImage reflectance, double[] roiPts, double[] gainAmbientLight) {
        CvMat invp;
        int w = cameraImages[0].width();
        int h = cameraImages[0].height();
        int channels = cameraImages[0].nChannels();
        IplImage mask = IplImage.create(w, h, 8, 1);
        opencv_core.cvSetZero(mask);
        opencv_imgproc.cvFillConvexPoly((CvArr)mask, new CvPoint((long)(roiPts.length / 2)).put((byte)(16 - this.cameraDevice.getMapsPyramidLevel()), roiPts), 4, CvScalar.WHITE, 8, 16);
        IplImage float1 = cameraImages[0];
        IplImage float2 = cameraImages[1];
        opencv_core.cvCopy(float2, reflectance);
        opencv_imgproc.cvSmooth(float1, float1, 2, this.smoothingSize, 0, 0.0, 0.0);
        opencv_imgproc.cvSmooth(float2, float2, 2, this.smoothingSize, 0, 0.0, 0.0);
        opencv_core.cvSub(float2, float1, float2, null);
        CvMat p = mat3x1.get();
        p.put(1.0, 1.0, 1.0);
        opencv_core.cvMatMul(this.projectorDevice.colorMixingMatrix, p, p);
        if (float2.nChannels() == 4) {
            invp = mat4x4.get();
            invp.put(1.0 / p.get(0), 0.0, 0.0, 0.0, 0.0, 1.0 / p.get(1), 0.0, 0.0, 0.0, 0.0, 1.0 / p.get(2), 0.0, 0.0, 0.0, 0.0, 1.0);
        } else {
            invp = mat3x3.get();
            invp.put(1.0 / p.get(0), 0.0, 0.0, 0.0, 1.0 / p.get(1), 0.0, 0.0, 0.0, 1.0 / p.get(2));
        }
        opencv_core.cvTransform(float2, float2, invp, null);
        FloatBuffer fb1 = float1.getFloatBuffer();
        FloatBuffer fb2 = float2.getFloatBuffer();
        ByteBuffer mb = mask.getByteBuffer();
        assert (fb1.capacity() == fb2.capacity() / 3);
        assert (fb1.capacity() == mb.capacity() / 3);
        int[] nPixels = new int[channels];
        int i = 0;
        for (int j = 0; j < fb1.capacity(); j += channels) {
            for (int z = 0; z < channels; ++z) {
                float ra = fb1.get(j + z);
                float r = fb2.get(j + z);
                float a = r == 0.0f ? 0.0f : ra / r;
                fb1.put(j + z, a);
                if (mb.get(i) == 0 || !((double)r > this.reflectanceMin)) continue;
                int n = z;
                nPixels[n] = nPixels[n] + 1;
                int n2 = z + 1;
                gainAmbientLight[n2] = gainAmbientLight[n2] + (double)a;
            }
            ++i;
        }
        gainAmbientLight[0] = 1.0;
        for (int z = 0; z < gainAmbientLight.length - 1; ++z) {
            gainAmbientLight[z + 1] = nPixels[z] == 0 ? 0.0 : gainAmbientLight[z + 1] / (double)nPixels[z];
        }
        opencv_core.cvAddS(float1, opencv_core.cvScalar(p.get(0), p.get(1), p.get(2), 0.0), float1, null);
        opencv_core.cvDiv(reflectance, float1, reflectance, 1.0);
        opencv_core.cvNot(mask, mask);
        opencv_imgproc.cvErode(mask, mask, null, 15);
        opencv_core.cvSet(reflectance, CvScalar.ZERO, mask);
        return reflectance;
    }

    public CvMat initializePlaneParameters(IplImage reflectance, IplImage cameraImage, double[] referencePoints, double[] roiPts, double[] gainAmbientLight) {
        int iterations;
        ProCamTransformer transformer = new ProCamTransformer(referencePoints, this.cameraDevice, this.projectorDevice, null);
        transformer.setProjectorImage(this.projectorImages[2], 0, this.alignerSettings.pyramidLevelMax);
        ProCamTransformer.Parameters parameters = transformer.createParameters();
        int gainAmbientLightStart = parameters.size() - gainAmbientLight.length;
        int gainAmbientLightEnd = parameters.size();
        for (int i = gainAmbientLightStart; i < gainAmbientLightEnd; ++i) {
            parameters.set(i, gainAmbientLight[i - gainAmbientLightStart]);
        }
        GNImageAligner aligner = new GNImageAligner(transformer, parameters, reflectance, roiPts, cameraImage, this.alignerSettings);
        double[] delta = new double[parameters.size() + 1];
        boolean converged = false;
        long iterationsStartTime = System.currentTimeMillis();
        for (iterations = 0; !converged && iterations < 100; ++iterations) {
            converged = aligner.iterate(delta);
        }
        parameters = (ProCamTransformer.Parameters)aligner.getParameters();
        Logger.getLogger(ReflectanceInitializer.class.getName()).info("iteratingTime = " + (System.currentTimeMillis() - iterationsStartTime) + "  iterations = " + iterations + "  objectiveRMSE = " + (float)aligner.getRMSE());
        return parameters.getN0();
    }
}

