package org.openqa.selenium.devtools.v141.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum DirectSocketDnsQueryType {

    IPV4("ipv4"), IPV6("ipv6");

    private String value;

    DirectSocketDnsQueryType(String value) {
        this.value = value;
    }

    public static DirectSocketDnsQueryType fromString(String s) {
        return java.util.Arrays.stream(DirectSocketDnsQueryType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DirectSocketDnsQueryType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DirectSocketDnsQueryType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
