package org.openqa.selenium.devtools.v141.media;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows detailed inspection of media elements.
 */
@Beta()
public class Media {

    /**
     * Enables the Media domain
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Media.enable", Map.copyOf(params));
    }

    /**
     * Disables the Media domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Media.disable", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v141.media.model.PlayerPropertiesChanged> playerPropertiesChanged() {
        return new Event<>("Media.playerPropertiesChanged", input -> input.read(org.openqa.selenium.devtools.v141.media.model.PlayerPropertiesChanged.class));
    }

    public static Event<org.openqa.selenium.devtools.v141.media.model.PlayerEventsAdded> playerEventsAdded() {
        return new Event<>("Media.playerEventsAdded", input -> input.read(org.openqa.selenium.devtools.v141.media.model.PlayerEventsAdded.class));
    }

    public static Event<org.openqa.selenium.devtools.v141.media.model.PlayerMessagesLogged> playerMessagesLogged() {
        return new Event<>("Media.playerMessagesLogged", input -> input.read(org.openqa.selenium.devtools.v141.media.model.PlayerMessagesLogged.class));
    }

    public static Event<org.openqa.selenium.devtools.v141.media.model.PlayerErrorsRaised> playerErrorsRaised() {
        return new Event<>("Media.playerErrorsRaised", input -> input.read(org.openqa.selenium.devtools.v141.media.model.PlayerErrorsRaised.class));
    }

    public static Event<org.openqa.selenium.devtools.v141.media.model.Player> playerCreated() {
        return new Event<>("Media.playerCreated", ConverterFunctions.map("player", org.openqa.selenium.devtools.v141.media.model.Player.class));
    }
}
