package org.openqa.selenium.devtools.v140.deviceaccess.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Device information displayed in a user prompt to select a device.
 */
public class PromptDevice {

    private final org.openqa.selenium.devtools.v140.deviceaccess.model.DeviceId id;

    private final java.lang.String name;

    public PromptDevice(org.openqa.selenium.devtools.v140.deviceaccess.model.DeviceId id, java.lang.String name) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
    }

    public org.openqa.selenium.devtools.v140.deviceaccess.model.DeviceId getId() {
        return id;
    }

    /**
     * Display name as it appears in a device request user prompt.
     */
    public java.lang.String getName() {
        return name;
    }

    private static PromptDevice fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v140.deviceaccess.model.DeviceId id = null;
        java.lang.String name = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v140.deviceaccess.model.DeviceId.class);
                    break;
                case "name":
                    name = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PromptDevice(id, name);
    }
}
