package org.openqa.selenium.devtools.v139.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Whether this is a sign-up or sign-in action for this account, i.e.
 * whether this account has ever been used to sign in to this RP before.
 */
public enum LoginState {

    SIGNIN("SignIn"), SIGNUP("SignUp");

    private String value;

    LoginState(String value) {
        this.value = value;
    }

    public static LoginState fromString(String s) {
        return java.util.Arrays.stream(LoginState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within LoginState "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static LoginState fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
